package net.haaks.spidertrap;

import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Sound;
import org.newdawn.slick.geom.Circle;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.util.Log;

public class Turret extends AbstractEntity implements Entity {

	private static Image[] turretImages = new Image[4];
	private Image img;
	private int timeTilNextShot = 0;
	private static int SHOOTINTERVAL = 3000;
	private int direction = NODIR;
	private Sound zap = RessourceManager.getSound("zap");

	public static Turret AddTurret(AreaMap map, Vector2f pos, int direction, CollisionGroup cg, GameContext context) {
		if (turretImages[UP] == null) {
			turretImages[UP] = RessourceManager.getImage("turretup");
			turretImages[DOWN] = RessourceManager.getImage("turretdown");
			turretImages[LEFT] = RessourceManager.getImage("turretleft");
			turretImages[RIGHT] = RessourceManager.getImage("turretright");
		}
		Turret turret;
		turret = new Turret(pos, direction, turretImages[direction]);
		turret.gameContext = context;
		map.addEntity(turret, AreaMap.GROUNDLAYER);
		turret.cg = cg;
		if (cg != null)
			turret.cg.add(turret);
		// start turret with a random time to avoid all turrets shooting at the same time
		turret.timeTilNextShot = turret.randomValue(0, SHOOTINTERVAL);
		return turret;
		
	}
	
	public Turret(Vector2f pos, int direction, Image img) {
		x = (int)pos.x * SpiderTrap.TILESIZE;
		y = (int)pos.y * SpiderTrap.TILESIZE;
		
		this.direction = direction;
		this.img = img;
		bounds = null;
		tile = pos;
		switch (direction) {
		case UP:
			toTile = new Vector2f(pos.x, pos.y+1);
			break;
		case DOWN:
			toTile = new Vector2f(pos.x, pos.y+1);
			break;
		case LEFT:
			toTile = new Vector2f(pos.x+1, pos.y);
			break;
		case RIGHT:
			toTile = new Vector2f(pos.x+1, pos.y);
			break;
		default:
			Log.error("Turret.Turret(): Illegal direction!");
			break;
				
		}
	}
	
	public void draw(Graphics g) {
		g.drawImage(img, x, y);
	}

	public Circle getBounds() {
		return null;
	}

	public Entity getOwner() {
		return this;
	}

	public boolean hitBy(Entity source) {
		Log.error("Turret.hitBy() should never happen");
		return false;
	}

	public void setMap(AreaMap map) {
		this.map = map;
	}

	public void update(int delta) {
		timeTilNextShot += delta;
		if (timeTilNextShot > SHOOTINTERVAL) {
			timeTilNextShot -= SHOOTINTERVAL;
			Vector2f bulletTile = toTile;
			switch (direction) {
			case UP:
//				bulletTile = new Vector2f(tile.x, tile.y-1);
				bulletTile = new Vector2f(tile.x, tile.y);
				break;
			case DOWN:
//				bulletTile = new Vector2f(toTile.x, toTile.y+1);
				bulletTile = new Vector2f(toTile.x, toTile.y);
				break;
			case LEFT:
//				bulletTile = new Vector2f(tile.x-1, tile.y);
				bulletTile = new Vector2f(tile.x, tile.y);
				break;
			case RIGHT:
//				bulletTile = new Vector2f(toTile.x+1, toTile.y);
				bulletTile = new Vector2f(toTile.x, toTile.y);
				break;
			default:
				Log.error("Turret.update(): Illegal direction!");
				break;
					
			}
			Bullet.AddBullet(map, bulletTile, CollisionGroup.GetGroup("bullets"), gameContext, direction);
			zap.play();
		}
	}

}
