package net.haaks.spidertrap;

import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Input;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;
import org.newdawn.slick.util.Log;

public class TitleState extends BasicGameState implements GameContext {
	
	private static SpriteSheet bigSpiderImages = null;

	private Font font, titlefont;
	private String title = "Welcome To SpiderTrap";
	/** The menu options */
	private String[] options = new String[] {"Start Game", "Resume Game", "Options", "Instructions","Highscores","Credits","Exit"};
	
	/** The index of the selected option */
	private int selected;
	/** The game holding this state */
	private StateBasedGame myGame;
	private GameContainer myContainer;
	
	private CollisionManager cgManager = CollisionManager.getSingleton();

	// graphics and sound stuff
	private Music music = null;

	private AreaMap map;	// the map for the background
	
	private CollisionGroup cgTitle = null;
	
	private double radiansCount = 0.0;
	private double scale;
	private double twoTimesPI = Math.PI * 2;
	
	private int index = 0;		// index to spider sprite
	private int nextstep = 0;
	private final int NEXTSTEP = 100;

	private SavedGameData savedGame = null;

	private boolean canResumeGame = false;
	private static Color disabled = new Color(255,255,255,100);
	
	@Override
	public int getID() {
		return SpiderTrap.TITLE_STATE;
	}

	public void init(GameContainer container, StateBasedGame game) throws SlickException {
		SpiderTrap.initRessources();
		
		font = RessourceManager.getAngelCodeFont("info");
		titlefont = RessourceManager.getAngelCodeFont("orangeinfo");
		bigSpiderImages = RessourceManager.getSpriteSheet("bigspider");
		this.myGame = game;
		this.myContainer = container;

		music = RessourceManager.getMusic("titlemusic");
		
		map = new AreaMap(this, "res/title.tmx");
		// center camera on map
		Vector2f center = new Vector2f(SpiderTrap.WIDTH_HALF, SpiderTrap.HEIGHT_HALF);
		map.setFocusObj(new SimpleMapFocus(center));
		map.setCameraStart(center);
		cgTitle = CollisionGroup.GetGroup("spiders");

	}

	public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
		if (map != null) {
			map.draw(g);
		}

		g.resetFont();
		g.setColor(Color.white);
		g.drawString(SpiderTrap.VERSION, 10, SpiderTrap.HEIGHT - 35);
		g.drawString(SpiderTrap.TOMMY, 10, SpiderTrap.HEIGHT - 25);
		g.drawString(SpiderTrap.CINFA, 10, SpiderTrap.HEIGHT - 15);
		g.setFont(titlefont);
		g.setColor(Color.white);
		g.drawString(title, SpiderTrap.WIDTH_HALF - (font.getWidth(title)/2), 50);
		
		int starty = 120;
		
		g.setFont(font);
		g.setColor(Color.white);
		for (int i=0;i<options.length;i++) {
			if (selected == i) {
				bigSpiderImages.getSprite(index, 0).draw(SpiderTrap.WIDTH_HALF - 180, starty+(i*50));
				bigSpiderImages.getSprite(index, 1).draw(SpiderTrap.WIDTH_HALF + (180-64), starty+(i*50));
				g.translate(SpiderTrap.WIDTH_HALF - (float)((font.getWidth(options[i]) * scale)/2), starty+(i*50));
				g.scale((float)scale, (float)scale);
				g.drawString(options[i], 0, 0);
				g.resetTransform();
			} else {
				if (i == 1 && !canResumeGame)
					g.setColor(disabled);
				g.drawString(options[i], SpiderTrap.WIDTH_HALF - (font.getWidth(options[i])/2), starty+(i*50));
				if (i == 1 && !canResumeGame)
					g.setColor(Color.white);
			}
		}
	}

	public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
		nextstep += delta;
		if (nextstep > NEXTSTEP) {
			nextstep -= NEXTSTEP;
			index++;
			if (index > 10)
				index = 0;
		}
		radiansCount += (0.004 * delta);
		if (radiansCount > twoTimesPI)
			radiansCount = 0.0;
	    scale = 0.9 + (0.3 * Math.sin(radiansCount));
		map.update(delta);
		cgManager.update();
		
	}

	
	public void keyReleased(int key, char c) {
		IngameState target;
		
		if (key == Input.KEY_DOWN) {
			selected++;
			if (selected == 1 && !canResumeGame)
				selected++;
			if (selected >= options.length) {
				selected = 0;
			}
		}
		if (key == Input.KEY_UP) {
			selected--;
			if (selected == 1 && !canResumeGame)
				selected--;
			if (selected < 0) {
				selected = options.length - 1;
			}
		}
		if (key == Input.KEY_ESCAPE) {
			myContainer.exit();
		}
		if (key == Input.KEY_RETURN) {
			switch (selected) {
				case 0: // start normal game
					target = (IngameState) myGame.getState(SpiderTrap.INGAME_STATE);
					target.setDifficulty(IngameState.NORMAL);
					target.restart(null);
					myGame.enterState(SpiderTrap.INGAME_STATE, new FadeOutTransition(Color.black), new FadeInTransition(Color.black));
					break;
				case 1: // resume game
					target = (IngameState) myGame.getState(SpiderTrap.INGAME_STATE);
					target.setDifficulty(savedGame.getDifficulty());
					target.restart(savedGame);
					myGame.enterState(SpiderTrap.INGAME_STATE, new FadeOutTransition(Color.black), new FadeInTransition(Color.black));
					break;
				case 2: // options
					myGame.enterState(SpiderTrap.OPTIONS_STATE, new FadeOutTransition(Color.black), new FadeInTransition(Color.black));
					break;
				case 3: // instructions
					myGame.enterState(SpiderTrap.INSTRUCTIONS_STATE, new FadeOutTransition(Color.black), new FadeInTransition(Color.black));
					break;
				case 4: // highscores
					GameOverState gos = (GameOverState) myGame.getState(SpiderTrap.GAMEOVER_STATE);
					gos.setEndgameData(new StateTransferData(0, 0, 0, 0, true));
					myGame.enterState(SpiderTrap.GAMEOVER_STATE, new FadeOutTransition(Color.black), new FadeInTransition(Color.black));
					break;
				case 5: // credits
					myGame.enterState(SpiderTrap.CREDITS_STATE, new FadeOutTransition(Color.black), new FadeInTransition(Color.black));
					break;
				case 6: // exit
					myContainer.exit();
					break;
			}
		}
	}

	
	public void enter(GameContainer container, StateBasedGame game) throws SlickException {
		Log.debug("TitleState.enter() is called");
		// reset to first menu item
		selected = 0;
		
		map.removeAllSpidersAndEggs();
		cgManager.clearAllCollisionGroups();
		Vector2f freepos = map.getFreePosition();
		Spider.AddSpider(map, freepos, cgTitle, this);
		if (!music.playing())
			music.loop();
		// check if we can resume a game
		savedGame = SavedGameData.load();
		if (savedGame == null)
			canResumeGame = false;
		else
			canResumeGame = true;
		Log.debug("Game can " + ((canResumeGame)? "" : "not") + " be resumed!");
	}

	public void leave(GameContainer container, StateBasedGame game) throws SlickException {
		Log.debug("TitleState.leave() is called");
		cgTitle.clear();
	}

	public void propagate(int notification, Vector2f tile, String infoString, Integer infoInt, Double infoDouble) {
		// we do nothing here; simply here to use spiders on the title screen 
	}

}
