package net.haaks.spidertrap;

import java.util.Random;

import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.Graphics;

public class TextScroller {
	// constants for possible appearance directions
	public static final int INSTANT = 0;
	public static final int MOVE_UP = 1;
	public static final int MOVE_DOWN = 2;
	public static final int MOVE_LEFT = 4;
	public static final int MOVE_RIGHT = 8;

	public static final int FORMAT_LEFT = 1;
	public static final int FORMAT_CENTER = 2;
	public static final int FORMAT_RIGHT = 3;

	private GameContext context;
	private int x,y;
	private int startx, starty, endx, endy, direction;
	private int time = 0;
	private int pixelPerTimeUpdate = 0;
	private int msWhenUpdate = 0;
	private String[] textLines;
	private int nrOfLines;
	private Font textFont;
	private Color textColor;
	private int textOrientation;
	private int textFontHeight;
	private int lineGap;
	private boolean reachedEndPosition = false;
	
	public static int RandomMove() {
		Random rndGen = new Random();
		int result = MOVE_DOWN;
		int dir = rndGen.nextInt(4);
		switch (dir) {
			case 0 : result = MOVE_UP; break;
			case 1 : result = MOVE_DOWN; break;
			case 2 : result = MOVE_LEFT; break;
			case 3 : result = MOVE_RIGHT; break;
		}
		return result;
	}
	
	public TextScroller(String[] text, Font font, Color col, int format, int x, int y, int dir, int ms, int pixels) {
		textLines = text;
		nrOfLines = text.length;
		endx = x; endy = y;
		direction = dir;
		msWhenUpdate = ms;
		pixelPerTimeUpdate = pixels;
		textFont = font;
		textColor = col;
		textFontHeight = font.getHeight("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
		textOrientation = format;
		lineGap = textFontHeight / 4;
		reachedEndPosition = false;
		// init start x and y position for text scroller
		startx = x; starty = y;
		if ((dir & MOVE_UP) > 0) {
			// start at the bottom of the screen and scroll up
			starty = SpiderTrap.HEIGHT;
		}
		if ((dir & MOVE_DOWN) > 0) {
			// start at the top of the screen (with the last line!) and scroll down
			starty = - SpiderTrap.HEIGHT;
		}
		if ((dir & MOVE_RIGHT) > 0) {
			// start at the left of the screen and scroll right
			startx = - SpiderTrap.WIDTH;
		}
		if ((dir & MOVE_LEFT) > 0) {
			// start at the right of the screen and scroll left
			startx = SpiderTrap.WIDTH;
		}
		if (dir == INSTANT) {
			reachedEndPosition = true;
		}
		reset();
	}
	
	public void reset() {
		x = startx;
		y = starty;
		time = 0;
	}
	
	public void update(int delta) {
		if (reachedEndPosition)
			return;
		boolean xposReached = false, yposReached = false;
		time += delta;
		if (time > msWhenUpdate) {
			time -= msWhenUpdate;
			if ((direction & MOVE_LEFT) > 0) {
				x -= pixelPerTimeUpdate;
				if (x < endx) {
					x = endx;
					xposReached = true;
				}
			} else if ((direction & MOVE_RIGHT) > 0) {
				x += pixelPerTimeUpdate;
				if (x > endx) {
					x = endx;
					xposReached = true;
				}
			} else {
				// no x movement
				xposReached = true;
			}
			if ((direction & MOVE_UP) > 0) {
				y -= pixelPerTimeUpdate;
				if (y < endy) {
					y = endy;
					yposReached = true;
				}
			} else if ((direction & MOVE_DOWN) > 0) {
				y += pixelPerTimeUpdate;
				if (y > endy) {
					y = endy;
					yposReached = true;
				}
			} else {
				// no y movement
				yposReached = true;
			}
			if (xposReached && yposReached)
				reachedEndPosition = true;
		}
	}
	
	public void render(Graphics g) {
		int lx, ly;
		
		lx = x;
		g.setFont(textFont);
		g.setColor(textColor);
		for (int i = 0; i < nrOfLines; i++) {
			switch (textOrientation) {
			case FORMAT_LEFT:
				lx = x;
				break;
			case FORMAT_CENTER:
				lx = x + (SpiderTrap.WIDTH_HALF - (textFont.getWidth(textLines[i])/2));
				break;
			case FORMAT_RIGHT:
				lx = SpiderTrap.WIDTH - x - textFont.getWidth(textLines[i]);
				break;
			}
			ly = y + (i * textFontHeight) + ((i > 0) ? (i-1)*lineGap : 0);
			g.drawString(textLines[i], lx, ly);
		}
		
	}
	

}
