package net.haaks.spidertrap;

import org.newdawn.slick.Graphics;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Circle;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.util.Log;

public class Teleporter extends AbstractEntity implements Entity {

	public enum State { CLOSED, OPENING, OPEN, CLOSING };
	
	private static SpriteSheet teleporterImages = null;
	private static Sound appearSound = null;

	private static final int MIN_OPEN_PHASE = 2000;
	private static final int NEXTPHASE = 100;
	private static final int FIRSTPHASE = 0;
	private static final int LASTPHASE = 7;

	private State state = State.CLOSED;
	private int phase = FIRSTPHASE;
	private int timer = 0;
	private boolean propagated = true;	// did we tell gamecontext to create new robot?

	private int robotToActivate;

	public static Teleporter AddTeleporter(AreaMap map, Vector2f pos, GameContext context) {
		Teleporter teleporter;
		
		if (teleporterImages == null) {
			teleporterImages = RessourceManager.getSpriteSheet("teleporter");
			appearSound = RessourceManager.getSound("appear");
		}
		teleporter = new Teleporter(pos);
		teleporter.gameContext = context;
		map.addEntity(teleporter, AreaMap.GROUNDLAYER);
		return teleporter;
		
	}
	
	public Teleporter(Vector2f startTile) {
		x = (int)startTile.x * SpiderTrap.TILESIZE;
		y = (int)startTile.y * SpiderTrap.TILESIZE;
		
		bounds = null;
		tile = startTile;
		toTile = null;
		phase = 0;
		state = State.CLOSED;
	}


	public void draw(Graphics g) {
		teleporterImages.getSprite(phase, 0).draw(x, y);
	}

	public Circle getBounds() {
		return null;
	}

	public Entity getOwner() {
		return this;
	}

	public boolean hitBy(Entity source) {
		// we don't care about collisions
		return false;
	}

	public void setMap(AreaMap map) {
		this.map = map;
	}

	public void update(int delta) {
		switch (state) {
		case OPEN:
			if (!propagated) {
				gameContext.propagate(GameContext.TELEPORTER_OPENED, tile, null, robotToActivate, null);
				propagated = true;
				timer = 0;
			}
			timer += delta;
			// close again if our position is empty
			if (timer > MIN_OPEN_PHASE && map.isPositionFree(tile, null)) {
				state = State.CLOSING;
				timer = 0;
			}
			break;
		case OPENING:
			timer += delta;
			if (timer > NEXTPHASE) {
				timer -= NEXTPHASE;
				phase ++;
				if (phase > LASTPHASE) {
					phase = LASTPHASE;
					state = State.OPEN;
				}
			}
			break;
		case CLOSING:
			timer += delta;
			if (timer > NEXTPHASE) {
				timer -= NEXTPHASE;
				phase --;
				if (phase < FIRSTPHASE) {
					phase = FIRSTPHASE;
					state = State.CLOSED;
				}
			}
			break;
		case CLOSED:
			timer = 0;
			break;
		}

	}
	
	public void openForRobot(int robot) {
//		if (!appearSound.playing())
		appearSound.stop();
		Log.debug("playing appearsound");
		appearSound.play();
		robotToActivate = robot;
		state = State.OPENING;
		propagated = false;		// need to tell game context when we are completely open
	}
}
