package net.haaks.spidertrap;

import java.util.ArrayList;

import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.particles.Particle;
import org.newdawn.slick.particles.ParticleEmitter;
import org.newdawn.slick.particles.ParticleSystem;

public class SplatEmitter implements ParticleEmitter {

	private SpriteSheet splatImages = null;
	private Image bigSplatImage = null;
	private ArrayList<Splat> newSplats = new ArrayList<Splat>();
	private boolean enabled = false;
	
	public SplatEmitter() throws SlickException {
		if (splatImages == null) {
			splatImages = new SpriteSheet("res/eggsplash.png", SpiderTrap.TILESIZE, SpiderTrap.TILESIZE, new Color(255,255,255));
			bigSplatImage = splatImages.getSprite(0,0);
		}
		enabled = true;
	}
	
	public void addSplat(float x, float y) {
		newSplats.add(new Splat(x,y));
	}
	
	public boolean completed() {
		return false;
	}

	public boolean isEnabled() {
		return enabled;
	}

	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}

	public void update(ParticleSystem system, int delta) {
		for (int i=0;i<newSplats.size();i++) {
			Splat splat = (Splat) newSplats.get(i);
			splat.spawn(system);
		}
		newSplats.clear();
	}

	public void updateParticle(Particle particle, int delta) {
		if (particle.getLife() < 500) {
			if (particle.getType() == 0) {
				particle.adjustSize(-delta * 0.02f);
				particle.adjustColor(0, 0, 0, -delta * 0.003f);
			} else {
				particle.adjustSize(-delta * 0.005f);
				particle.adjustColor(0, 0, 0, -delta * 0.001f);
			}
		}
	}

	private class Splat {
		public float x;
		public float y;
		
		public Splat(float x, float y) {
			this.x = x;
			this.y = y;
		}

		public void spawn(ParticleSystem system) {
			for (int i=0;i<3;i++) {
				Particle p = system.getNewParticle(SplatEmitter.this, 5000+(float)Math.random()*2000);
				p.setType(1);
				float dx = (float) (Math.random() * 2) - 1;
				float dy = (float) (Math.random() * 2) - 1;
				float dis = (float) (Math.random() * 15);
				float size = (float) ((Math.random() * 15) + 15);
				
				p.setPosition(x + (dis * dx), y + (dis * dy));
				p.setSize(size);
				p.setColor(1,1,1,0.8f);
				p.setImage(bigSplatImage);
			}
		}
	}

}
