package net.haaks.spidertrap;

import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.util.Log;

/**
 * @author Tommy
 *
 */
public class SpiderTrap extends StateBasedGame {
	
	public static final String VERSION = "Version 1.2 made by";
	public static final String TOMMY = "Tommy (www.haaks.net) and";
	public static final String CINFA = "Cinfa (www.bottomap.com)";
	
	public static final int WIDTH = 640;
	public static final int HEIGHT = 480;
	public static final int WIDTH_HALF = 320;
	public static final int HEIGHT_HALF = 240;

	public static final int TILESIZE = 32;
	public static final int TILESIZE_HALF = 16;
	
	// static finals for the game state ids, defined here to avoid duplicate gamestate definitions
	public static final int TITLE_STATE = 1;
	public static final int INGAME_STATE = 2;
	public static final int NEXTLEVEL_STATE = 3;
	public static final int GAMEOVER_STATE = 4;
	public static final int CREDITS_STATE = 5;
	public static final int INSTRUCTIONS_STATE = 6;
	public static final int OPTIONS_STATE = 7;
	
	/** volume for SFX and music */
	public static float musicVolume = 1.0f;
	public static float sfxVolume = 1.0f;
	
	public static boolean wizardMode = false;
	
	public static boolean ressourcesInited = false;
	
	
	private AppGameContainer container;
	
	public SpiderTrap() throws SlickException {
		super("SpiderTrap");
	}
	

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		if (args.length == 1 && args[0].equals("wizard"))
			wizardMode = true;
		
		try {
//			Log.setVerbose(false);
			AppGameContainer container = new AppGameContainer(new SpiderTrap());
			container.setDisplayMode(WIDTH, HEIGHT, false);
//			container.setShowFPS(false);
			// switch off mouse cursor
			container.start();
		} catch (SlickException e) {
			e.printStackTrace();
		}
	}

	@Override
	public void initStatesList(GameContainer container) {
		if (container instanceof AppGameContainer) {
			this.container = (AppGameContainer) container;
		}
		addState(new TitleState());
		addState(new CreditsState());
		addState(new InstructionsState());
		addState(new IngameState());
		addState(new NextLevelState());
		addState(new GameOverState());
		addState(new OptionsState());
		
		applyGameOptions();
	}

	/**
	 * @see org.newdawn.slick.state.StateBasedGame#keyPressed(int, char)
	 */
	public void keyPressed(int key, char c) {
		super.keyPressed(key, c);

		if (key == Input.KEY_F2) {
			if (container != null) {
				try {
					container.setFullscreen(!container.isFullscreen());
					if (container.isFullscreen())
						container.setMouseGrabbed(true);
				} catch (SlickException e) {
					Log.error(e);
				}
			}
		}
	}
	
	public static void initRessources() throws SlickException {
		if (ressourcesInited)
			return;
		// fonts
//		RessourceManager.loadAngelCodeFontAs("info", "res/HieroSFComicScript32.fnt","res/HieroSFComicScript32.png");
//		RessourceManager.loadAngelCodeFontAs("hud", "res/HieroSFComicScript24.fnt","res/HieroSFComicScript24.png");
		RessourceManager.loadAngelCodeFontAs("info", "res/HemiHead426-32.fnt","res/HemiHead426-32.png");
		RessourceManager.loadAngelCodeFontAs("orangeinfo", "res/HemiHead426-32orange.fnt","res/HemiHead426-32orange.png");
		RessourceManager.loadAngelCodeFontAs("hud", "res/HemiHead426-24.fnt","res/HemiHead426-24.png");
		RessourceManager.loadAngelCodeFontAs("redhud", "res/HemiHead426-24red.fnt","res/HemiHead426-24red.png");
		// images
		RessourceManager.loadImageAs("turretup", "res/turretup.png");
		RessourceManager.loadImageAs("turretdown", "res/turretdown.png");
		RessourceManager.loadImageAs("turretleft", "res/turretleft.png");
		RessourceManager.loadImageAs("turretright", "res/turretright.png");
		RessourceManager.loadImageAs("energy", "res/Energy.png");
		// spritesheets
		RessourceManager.loadSpriteSheetAs("sucker", "res/blobby.png",
//				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE, new Color(255, 255, 255));
				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE);
		RessourceManager.loadSpriteSheetAs("spider", "res/Spider.png",
				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE);
		RessourceManager.loadSpriteSheetAs("bigspider", "res/BigSpiders.png",
				SpiderTrap.TILESIZE*2, SpiderTrap.TILESIZE*2);
		RessourceManager.loadSpriteSheetAs("spiderstunned", "res/SpiderStunned.png",
				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE);
		RessourceManager.loadSpriteSheetAs("egg", "res/egg.png",
				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE);
		RessourceManager.loadSpriteSheetAs("eggbroken", "res/eggbroken.png",
				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE);
		RessourceManager.loadSpriteSheetAs("teleporter", "res/hatch.png",
				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE);
		RessourceManager.loadSpriteSheetAs("guardian", "res/guardian.png",
//				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE, new Color(255,255,255));
				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE);
		RessourceManager.loadSpriteSheetAs("clock", "res/clock.png",
//				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE, new Color(255,255,255));
				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE);
		RessourceManager.loadSpriteSheetAs("battery", "res/battery.png",
//				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE, new Color(255,255,255));
				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE);
		RessourceManager.loadSpriteSheetAs("robots", "res/robots.png",
//				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE, new Color(255,0,255));
				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE);
		RessourceManager.loadSpriteSheetAs("activerobots", "res/activerobots.png",
				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE);
		RessourceManager.loadSpriteSheetAs("shield", "res/shield.png",
				SpiderTrap.TILESIZE, SpiderTrap.TILESIZE, new Color(255,0,255));
		// volumes for sound and music
//		RessourceManager.setSfxVolume(sfxVolume);
//		RessourceManager.setMusicVolume(musicVolume);
		// sounds
		RessourceManager.loadSoundAs("nope", "res/nope.wav");
		RessourceManager.loadSoundAs("appear", "res/electronic arm.wav");
		RessourceManager.loadSoundAs("bonus", "res/Fanfare-Public_D-32.wav");
		RessourceManager.loadSoundAs("zap", "res/Tinyzap1.wav");
		RessourceManager.loadSoundAs("bonus2", "res/RewardSo-Mark_E_B-1131.wav");
		RessourceManager.loadSoundAs("smallexplosion", "res/smallexplosion.wav");
		RessourceManager.loadSoundAs("computerexplosion", "res/computerexplosion.wav");
		RessourceManager.loadSoundAs("buzz", "res/LightBuzz.ogg");
		// music
		RessourceManager.loadMusicAs("ingamemusic", "res/freefall.mod");
		RessourceManager.loadMusicAs("titlemusic", "res/androidr.mod");

		// collision stuff
		CollisionGroup cgRobots, cgSpiders, cgEggs, cgComputers, cgBullets, cgGuards, cgSucker, cgBoni;
		cgRobots = CollisionGroup.GetGroup("robots");
		cgSpiders = CollisionGroup.GetGroup("spiders");
		cgEggs = CollisionGroup.GetGroup("eggs");
		cgComputers = CollisionGroup.GetGroup("computer");
		cgBullets = CollisionGroup.GetGroup("bullets");
		cgGuards = CollisionGroup.GetGroup("guards");
		cgSucker = CollisionGroup.GetGroup("sucker");
		cgBoni = CollisionGroup.GetGroup("boni");

		CollisionManager cgManager = CollisionManager.getSingleton();
		cgManager.addCollisionTupel(cgSpiders, cgSpiders);	// check spider - spider collisions
		cgManager.addCollisionTupel(cgRobots, cgEggs);		// check robot - egg collisions (robots destroy eggs)
		cgManager.addCollisionTupel(cgSpiders, cgComputers);	// spiders destroy computers
		cgManager.addCollisionTupel(cgRobots, cgComputers);	// robots destroy computers
		cgManager.addCollisionTupel(cgGuards, cgComputers);	// guards destroy computers
//		cgManager.addCollisionTupel(cgSpiders, cgBullets);
		cgManager.addCollisionTupel(cgRobots, cgBullets);
		cgManager.addCollisionTupel(cgRobots, cgGuards);	// guards destroy robots
//		cgManager.addCollisionTupel(cgSpiders, cgGuards);	// guards also destroy spiders. life is hard.
		cgManager.addCollisionTupel(cgRobots, cgBoni);		// robots can pick up boni
		cgManager.addCollisionTupel(cgRobots, cgSucker);	// sucker steal energy from robots
		
		ressourcesInited = true;
	}


	private void applyGameOptions() {
		RessourceManager.setMusicVolume(GameOptions.get().getMusicVolume());
		RessourceManager.setSfxVolume(GameOptions.get().getSfxVolume());
		IngameState igs = (IngameState) this.getState(INGAME_STATE);
		igs.setSkipTutorialLevels(GameOptions.get().isSkipTutorials());
	}
}
