package net.haaks.spidertrap;

import java.io.IOException;

import org.newdawn.slick.SavedState;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.util.Log;

public class SavedGameData {
	private static String saveName = "SpiderTrapSaveGame";

	private int score = 0;
	private int level = 0;
	private int fileLevel = 0;
	private int difficulty = 0;
	private int energy = 0;
	private static SavedState storage = null;
	
	private SavedGameData() {
	}
	
	public static SavedGameData load() {
		try {
			if (storage == null)
				storage = new SavedState(saveName);
			if (storage != null)
				storage.load();
		} catch (SlickException e) {
			Log.error("Creating storage for saved game state failed!");
			Log.error(e);
			return null;
		} catch (IOException ie) {
			Log.error("Loading saved game state failed!");
			Log.error(ie);
			return null;
		}
		// check if storage is empty. This happens when the storage does not yet exist or is cleared.
		int testScore = (int) storage.getNumber("score", -666);
		if (testScore == -666)
			return null;
		
		// aah, we have a valid storage
		SavedGameData res = new SavedGameData();
		res.setScore((int)storage.getNumber("score"));
		res.setEnergy((int)storage.getNumber("energy"));
		res.setLevel((int)storage.getNumber("level"));
		res.setFileLevel((int)storage.getNumber("filelevel"));
		res.setDifficulty((int)storage.getNumber("difficulty"));
		Log.debug("SavedGameData.load(): score = " + res.getScore());
		Log.debug("SavedGameData.load(): energy = " + res.getEnergy());
		Log.debug("SavedGameData.load(): level = " + res.getLevel());
		Log.debug("SavedGameData.load(): filelevel = " + res.getFileLevel());
		Log.debug("SavedGameData.load(): difficulty = " + res.getDifficulty());
		return res;
	}
	
	public static boolean save(int score, int energy, int level, int fileLevel, int difficulty) {
		try {
			if (storage == null)
				storage = new SavedState(saveName);
			storage.setNumber("score", (double) score);
			storage.setNumber("energy", (double) energy);
			storage.setNumber("level", (double) level);
			storage.setNumber("filelevel", (double) fileLevel);
			storage.setNumber("difficulty", (double) difficulty);
			storage.save();
		} catch (SlickException e) {
			Log.error("Creating storage for saved game state failed!");
			Log.error(e);
			return false;
		} catch (IOException ie) {
			Log.error("Saving saved game state failed!");
			Log.error(ie);
			return false;
		}
		Log.debug("SavedGameData.save(): score = " + score);
		Log.debug("SavedGameData.save(): energy = " + energy);
		Log.debug("SavedGameData.save(): level = " + level);
		Log.debug("SavedGameData.save(): filelevel = " + fileLevel);
		Log.debug("SavedGameData.save(): difficulty = " + difficulty);
		return true;
	}
	
	public static boolean clear() {
		if (storage == null)
			return true;
		try {
			storage.clear();
			storage.save();
		} catch (IOException e) {
			Log.error("Creating or clearing storage for saved game state failed!");
			Log.error(e);
			return false;
		}
		Log.debug("SavedGameData.clear() succeeded");
		return true;
	}

	public int getDifficulty() {
		return difficulty;
	}

	public void setDifficulty(int difficulty) {
		this.difficulty = difficulty;
	}

	public int getEnergy() {
		return energy;
	}

	public void setEnergy(int energy) {
		this.energy = energy;
	}

	public int getFileLevel() {
		return fileLevel;
	}

	public void setFileLevel(int fileLevel) {
		this.fileLevel = fileLevel;
	}

	public int getLevel() {
		return level;
	}

	public void setLevel(int level) {
		this.level = level;
	}

	public int getScore() {
		return score;
	}

	public void setScore(int score) {
		this.score = score;
	}
}
