package net.haaks.spidertrap;

import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Circle;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.util.Log;

public class Robot extends AbstractEntity {
	private static SpriteSheet robotImages = null;
	private static SpriteSheet activeRobotImages = null;
	private static Sound explosion = null;
//	private static Sound buzz = null;
	private static final int BOUNDSRADIUS = 14;

	private boolean theActiveOne = false;	// is this robot the current active one
	private boolean moving = false;
	private boolean turning = false;	// if true robot turns to a new direction
	private boolean destroyed = false;
	private int turnInc = 0;			// either 1 or -1, depending on direction of turn
	private int sheetIndex = 0;
	private int id = 0;
	private int nextStep = 0;
	private int nextTurn = 0;
	private final int NEXTSTEP = 25;	// in milliseconds
	private final int NEXTTURN = 100;	// in milliseconds
	private int SPEED = 2;
	private AngelCodeFont nrFont = null;
	private int direction = NODIR;
	private int sheetIndices[] = {6, 0, 2, 4}; // for up, right, down, left
	private int targetSheetIndex = sheetIndices[DOWN];
	private Color activeColor = new Color(0, 0, 255, 64);	// a blue color but very transparent

	public Robot(AreaMap map, Vector2f startTile, int robotid, CollisionGroup cg, GameContext context, AngelCodeFont font) {
		if (robotImages == null) {
			robotImages = RessourceManager.getSpriteSheet("robots");
			activeRobotImages = RessourceManager.getSpriteSheet("activerobots");
			explosion = RessourceManager.getSound("smallexplosion");
//			buzz = RessourceManager.getSound("buzz");
		}
		
		this.gameContext = context;
		this.nrFont = font;
		id = robotid;
		x = (int)startTile.x * SpiderTrap.TILESIZE;
		y = (int)startTile.y * SpiderTrap.TILESIZE;
		
		direction = DOWN;
		sheetIndex = sheetIndices[direction];	// looking down
		bounds = new Circle(x+SpiderTrap.TILESIZE_HALF, y+SpiderTrap.TILESIZE_HALF, BOUNDSRADIUS);
		offsetBoundsX = SpiderTrap.TILESIZE_HALF - BOUNDSRADIUS;
		offsetBoundsY = SpiderTrap.TILESIZE_HALF - BOUNDSRADIUS;
		moving = false;
		destroyed = false;
		tile = startTile;
		toTile = null;
		map.addEntity(this, AreaMap.OBJECTLAYER);
		// add ball to collision group
		this.cg = cg;
		cg.add(this);
	}
	

	public void update(int delta) {
		String[] collGroups = {"robots","spiders","guards"};
		
		// Log.debug("delta=" + delta + ", nextStep=" + nextStep);
		if (!moving) {
			// check for new direction
			if (desiredx != 0 || desiredy != 0) {
				// let's see if the tile in desired direction is free
				Vector2f targetTile = new Vector2f(tile.x + desiredx, tile.y + desiredy);
				if (map.isPositionFree(collGroups, targetTile)) {
					// Log.debug("position " + targetTile.toString() + " is collision free!");
					moving = true;
//					if (!buzz.playing())
//						buzz.play();
					int targetDirection = AbstractEntity.DirectionFromDeltaXY(desiredx, desiredy);
					// Log.debug("targetDirection is " + targetDirection);
					if (targetDirection != direction) {
						turning = true;
						targetSheetIndex = sheetIndices[targetDirection];
						if (targetDirection > direction)
							turnInc = 1;
						else
							turnInc = -1;
						direction = targetDirection;
					}
					dx = desiredx * SPEED;
					dy = desiredy * SPEED;
					toTile = targetTile;
				}
//			} else {
//				buzz.stop();
			}
		}
		if (turning) {
			nextTurn += delta;
			if (nextTurn > NEXTTURN) {
				nextTurn -= NEXTTURN;
				if (sheetIndex != targetSheetIndex) {
					sheetIndex += turnInc;
					if (sheetIndex < 0)
						sheetIndex = 7;
					if (sheetIndex > 7)
						sheetIndex = 0;
					if (sheetIndex == targetSheetIndex) {
						turning = false;
						nextTurn = 0;
					}
				}
			}
		}
		// now we are really moving. moving stops if we reached a new tile completely.
		if (moving) {
//			if (!buzz.playing())
//				buzz.play();
			nextStep += delta;
			if (nextStep >= NEXTSTEP) {
				x += dx;
				y += dy;
				nextStep -= NEXTSTEP;
				if (x % SpiderTrap.TILESIZE == 0 && y % SpiderTrap.TILESIZE == 0) {
					// reached the next tile. stop moving.
					moving = false;
					tile = toTile; toTile = null;
					nextStep = 0;
				}
			}
			bounds.setX(x+offsetBoundsX);
			bounds.setY(y+offsetBoundsY);
		}
	}
	
	
	public void draw(Graphics g) {
		// am I the active robot?
		if (theActiveOne) {
			activeRobotImages.getSprite(sheetIndex, 0).draw(x, y);
		} else {
			robotImages.getSprite(sheetIndex, 0).draw(x, y);
		}
		g.setFont(nrFont);
		g.setColor(Color.white);
		g.drawString(""+id, x+8, y-24);
//		img.draw(x,y);
//		g.setColor(Color.red);
//		g.draw(bounds);
	}

	public Circle getBounds() {
		return bounds;
	}

	public Entity getOwner() {
		return this;
	}

	public void setMap(AreaMap map) {
		this.map = map;
	}

	public boolean hitBy(Entity source) {
		if (destroyed)
			return true;
		if (source instanceof Bullet || source instanceof Guardian) {
			// bullets and guardians kill us
			destroyed = true;
			gameContext.propagate(GameContext.ROBOTDESTROYED, tile, null, new Integer(id-1), null);
			map.removeEntity(this);
			map.addExplosion(x + SpiderTrap.TILESIZE_HALF, y + SpiderTrap.TILESIZE_HALF);
			explosion.play();
			return true; // remove us from our collision group
		}
		return false;	// don't remove this ball from the collision group
	}


	public boolean isTheActiveOne() {
		return theActiveOne;
	}


	public void setTheActiveOne(boolean theActiveOne) {
		this.theActiveOne = theActiveOne;
	}

}
