package net.haaks.spidertrap;

import java.util.Collection;
import java.util.HashMap;

import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.util.Log;

public class RessourceManager {
	private static float sfxVolume = 1.0f;
	private static float musicVolume = 1.0f;
	
	private static HashMap<String,Sound> sounds = new HashMap<String, Sound>();
	private static HashMap<String,Music> songs = new HashMap<String, Music>();
	private static HashMap<String,Image> images = new HashMap<String, Image>();
	private static HashMap<String,SpriteSheet> sheets = new HashMap<String, SpriteSheet>();
	private static HashMap<String,AngelCodeFont> fonts = new HashMap<String, AngelCodeFont>();
	
	public static void loadMusicAs(String key, String file) throws SlickException {
		if (songs.get(key)!= null)
			throw new SlickException("Music for key " + key + " already existing!");
		Music song = new Music(file);
		songs.put(key, song);
	}
	
	public static Music getMusic(String key) {
		Music music = songs.get(key);
		if (music == null)
			Log.error("No music for key" + key + " found!");
		return music;
	}
	
	public static void loadSoundAs(String key, String file) throws SlickException {
		if (sounds.get(key)!= null)
			throw new SlickException("Sound for key " + key + " already existing!");
		Sound sound = new Sound(file);
		sounds.put(key, sound);
	}
	
	public static Sound getSound(String key) {
		Sound sound = sounds.get(key);
		if (sound == null)
			Log.error("No sound for key" + key + " found!");
		return sound;
	}

	public static void loadImageAs(String key, String file) throws SlickException {
		if (images.get(key)!= null)
			throw new SlickException("Image for key " + key + " already existing!");
		Image img = new Image(file);
		images.put(key, img);
	}
	
	public static Image getImage(String key) {
		Image image = images.get(key);
		if (image == null)
			Log.error("No image for key" + key + " found!");
		return image;
	}
	
	public static void loadSpriteSheetAs(String key, String file, int width, int height) throws SlickException {
		if (sheets.get(key)!= null)
			throw new SlickException("SpriteSheet for key " + key + " already existing!");
		SpriteSheet spriteSheet = new SpriteSheet(file, width, height);
		sheets.put(key, spriteSheet);
	}
	
	public static void loadSpriteSheetAs(String key, String file, int width, int height, Color transparent) throws SlickException {
		if (sheets.get(key)!= null)
			throw new SlickException("SpriteSheet for key " + key + " already existing!");
		SpriteSheet spriteSheet = new SpriteSheet(file, width, height, transparent);
		sheets.put(key, spriteSheet);
	}

	public static SpriteSheet getSpriteSheet(String key) {
		SpriteSheet spriteSheet = sheets.get(key);
		if (spriteSheet == null)
			Log.error("No SpriteSheet for key" + key + " found!");
		return spriteSheet;
	}
	
	public static void loadAngelCodeFontAs(String key, String fntfile, String imagefile) throws SlickException {
		if (fonts.get(key)!= null)
			throw new SlickException("AngelCodeFont for key " + key + " already existing!");
		// load AngelCodeFonts with caching enabled to speed up rendering
		AngelCodeFont font = new AngelCodeFont(fntfile, imagefile, true);
		fonts.put(key, font);
	}
	
	public static AngelCodeFont getAngelCodeFont(String key) {
		AngelCodeFont font = fonts.get(key);
		if (font == null)
			Log.error("No AngelCodeFont for key" + key + " found!");
		return font;
	}

	/**
	 * set the volume of all sound effects to given volume
	 * @param sfxVolume a value between 0 and 1
	 */
	public static void setSfxVolume(float volume) {
		sfxVolume = volume;
		SoundStore.get().setSoundVolume(sfxVolume);
		Log.debug("sfx volume set to " + sfxVolume);
	}

	/**
	 * set the volume of all songs to given volume
	 * @param musicVolume a value between 0 and 1
	 */
	public static void setMusicVolume(float volume) {
		musicVolume = volume;
		SoundStore.get().setMusicVolume(musicVolume);
		Log.debug("music volume set to " + musicVolume);
	}

	public static float getMusicVolume() {
		return musicVolume;
	}

	public static float getSfxVolume() {
		return sfxVolume;
	}
	
}
