package net.haaks.spidertrap;

import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;
import org.newdawn.slick.util.Log;

public class NextLevelState extends BasicGameState implements GameContext {

	private StateBasedGame myGame = null;
	private StateTransferData data = null;
	
	private String[] nextLevelText;
	private TextScroller infoText;
	private Font infoFont;
	private Color infoColor = Color.white;
	
	private boolean stateLeft = true;

	@Override
	public int getID() {
		return SpiderTrap.NEXTLEVEL_STATE;
	}

	public void propagate(int notification, Vector2f tile, String infoString, Integer infoInt, Double infoDouble) {
	}

	public void init(GameContainer container, StateBasedGame game) throws SlickException {
		SpiderTrap.initRessources();
		
		myGame = game;
//		infoFont = new AngelCodeFont("res/HieroSFComicScript24.fnt","res/HieroSFComicScript24.png");
		infoFont = RessourceManager.getAngelCodeFont("info");
	}

	public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
		if (stateLeft)
			return;
		if (infoText != null)
			infoText.render(g);

	}

	public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
		if (stateLeft)
			return;
		if (infoText != null)
			infoText.update(delta);

	}

	public void enter(GameContainer container, StateBasedGame game) throws SlickException {
		Log.debug("NextLevelState.enter() is called");
		if (data == null)
			throw new SlickException("NextLevelState.enter(): data is null!");
		String[] text = {
				"",
				"Well done!",
				"",
				"You mastered level " + data.getLevel(),
				"with a score of " + (data.getScore() - data.getTimebonus()),
				"Your time bonus is " + data.getTimebonus(),
				"New score is " + data.getScore(),
				"",
				"Press Space to continue with next level"
		};
		nextLevelText = text;
		infoText = new TextScroller(nextLevelText, infoFont, infoColor, TextScroller.FORMAT_CENTER,
				0, 0, TextScroller.RandomMove(), 10, 4);
		stateLeft = false;

	}

	public void leave(GameContainer container, StateBasedGame game) throws SlickException {
		Log.debug("NextLevelState.leave() is called");
		stateLeft = true;
	}

	public void setTransferData(StateTransferData data) {
		this.data = data;
	}

	public void keyReleased(int key, char c) {
		if (key == Input.KEY_ESCAPE) {
			// back to title menu
			myGame.enterState(SpiderTrap.TITLE_STATE, new FadeOutTransition(Color.black), new FadeInTransition(Color.black));
		}
		if (key == Input.KEY_SPACE) {
			// continue with next level
			myGame.enterState(SpiderTrap.INGAME_STATE, new FadeOutTransition(Color.black), new FadeInTransition(Color.black));
		}
	}

}
