package net.haaks.spidertrap;

import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Input;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;
import org.newdawn.slick.util.Log;

public class InstructionsState extends BasicGameState implements GameContext {

	private Font bigFont, smallFont;
	private TextScroller titleText = null, instructionsText = null;
	
	private String[] title = { "Instructions" };
	
	private String[] controls = {
		"Keys 1 to 8 activate the robots 1 to 8",
		"Cursor keys control the active robot",
		"P pauses the game,",
		"F2 toggles fullscreen/windowed",
		"Esc leaves the game/title",
		"",
		"",
		"",
		"",
		"",
		"Press Space for story, Escape for main menu"
	};
	
	private String[] story = {
		"Those scientists messed it up again, as usual!",
		"The dangerous spiders escaped and it's up to you",
		"and your cleaning bots to trap those spiders.",
		"But beware:",
		"active spiders can wake up stunned spiders,",
		"computer shields only last two minutes,",
		"spiders destroy unshielded computers,",
		"after two more minutes all computers explode,",
		"there are more unknown obstacles...",
		"",
		"Press Space for controls, Escape for main menu"
	};
	
	private String[] instructions;

	/** The game holding this state */
	private StateBasedGame myGame;
	private GameContainer myContainer;

	// graphics and sound stuff
	private Music music = null;

	private AreaMap map;	// the map for the background
	
	private CollisionManager cgManager = CollisionManager.getSingleton();
	private CollisionGroup cgInstructions = null;

	@Override
	public int getID() {
		return SpiderTrap.INSTRUCTIONS_STATE;
	}

	public void propagate(int notification, Vector2f tile, String infoString,
			Integer infoInt, Double infoDouble) {
	}

	public void init(GameContainer container, StateBasedGame game)
			throws SlickException {
		SpiderTrap.initRessources();
		
		bigFont = RessourceManager.getAngelCodeFont("orangeinfo");
		smallFont = RessourceManager.getAngelCodeFont("hud");
		this.myGame = game;
		this.myContainer = container;

		music = RessourceManager.getMusic("titlemusic");
		
		map = new AreaMap(this, "res/title.tmx");
		// center camera on map
		Vector2f center = new Vector2f(SpiderTrap.WIDTH_HALF, SpiderTrap.HEIGHT_HALF);
		map.setFocusObj(new SimpleMapFocus(center));
		map.setCameraStart(center);
		cgInstructions = CollisionGroup.GetGroup("spiders");

		instructions = story;
	}

	public void enter(GameContainer container, StateBasedGame game) throws SlickException {
		Log.debug("InstructionsState.enter() is called");

		map.removeAllSpidersAndEggs();
		cgManager.clearAllCollisionGroups();
		Vector2f freepos = map.getFreePosition();
		Spider.AddSpider(map, freepos, cgInstructions, this);

		titleText = new TextScroller(title, bigFont, Color.white, TextScroller.FORMAT_CENTER,
				0, 10, TextScroller.MOVE_UP, 20, 2);
		instructionsText = new TextScroller(instructions, smallFont, Color.white, TextScroller.FORMAT_LEFT,
				5, 40, TextScroller.MOVE_UP, 25, 2);
		if (!music.playing())
			music.loop();
	}

	public void leave(GameContainer container, StateBasedGame game) throws SlickException {
		Log.debug("InstructionsState.leave() is called");
		cgInstructions.clear();
	}

	public void render(GameContainer container, StateBasedGame game, Graphics g)
			throws SlickException {
		if (map != null) {
			map.draw(g);
		}
		if (titleText != null)
			titleText.render(g);
		if (instructionsText != null)
			instructionsText.render(g);
	}

	public void update(GameContainer container, StateBasedGame game, int delta)
			throws SlickException {
		map.update(delta);
		cgManager.update();
		titleText.update(delta);
		instructionsText.update(delta);
	}

	public void keyReleased(int key, char c) {
		if (key == Input.KEY_SPACE) {
			if (instructions == story)
				instructions = controls;
			else
				instructions = story;
			instructionsText = new TextScroller(instructions, smallFont, Color.white, TextScroller.FORMAT_LEFT,
					5, 40, TextScroller.MOVE_UP, 25, 2);
			
		}
		if (key == Input.KEY_ESCAPE) {
			// back to title menu
			myGame.enterState(SpiderTrap.TITLE_STATE, new FadeOutTransition(Color.black),
					new FadeInTransition(Color.black));
		}
	}

}
