package net.haaks.spidertrap;

import java.io.IOException;

import org.newdawn.slick.SavedState;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.util.Log;

public class HighscoreList {
	public static final int MAX_ENTRIES = 5;
	private static String savename = "SpiderTrapScores";
	
	private String[] names = new String[MAX_ENTRIES];
	private int[] scores = new int[MAX_ENTRIES];
	private SavedState storage = null;
	
	public HighscoreList() {
		this(savename);
	}
	
	public HighscoreList(String name) {
		// try to load an existing highscorelist from savestate, otherwise create a default one
		try {
			storage = new SavedState(name);
		} catch (SlickException e) {
			Log.error(e);
		}
		if (storage != null){
			boolean retval = loadHighscores();
			if (!retval)
				Log.debug("HighscoreList(): could not load highscores...");
		}
		
	}
	
	
	private boolean loadHighscores() {
		try {
			storage.load();
		} catch (IOException e) {
			Log.error("Loading Highscores failed");
			Log.error(e);
		}
		// put loaded values into arrays
		for (int i = 0; i < MAX_ENTRIES; i++) {
			String score = "score" + i;
			String name = "name" + i;
			scores[i] = (int) storage.getNumber(score, (MAX_ENTRIES - i) * 1000);
			names[i] = storage.getString(name, "Tommy");
		}
		return true;
	}
	
	public int getHighscoreAt(int index) {
		if (index >= 0 && index < MAX_ENTRIES)
			return scores[index];
		return (-666);
	}

	public String getNameAt(int index) {
		if (index >= 0 && index < MAX_ENTRIES)
			return names[index];
		return ("Unknown");
	}


	public boolean isHighscore(int score) {
		if (scores != null) {
			for (int i = 0; i < MAX_ENTRIES; i++) {
				if (score > scores[i])
					return true;
			}
		}
		return false;
	}
	
	public boolean insertHighscore(int score, String name) {
		if (scores != null) {
			if (!isHighscore(score))
				return false;	// should not happen but who knows...
			// now insert the highscore, we know it is one
			int pos = 0;
			while (scores[pos] > score)
				pos++;
			// new score goes at pos, all others go one down
			for (int i = MAX_ENTRIES - 1; i > pos; i--) {
				scores[i] = scores[i-1];
				names[i] = names[i-1];
			}
			scores[pos] = score;
			names[pos] = name;
			
			// finally save it
			return saveHighscores();
		}
		return false;
	}
	
	
	private boolean saveHighscores() {
		for (int i = 0; i < MAX_ENTRIES; i++) {
			String score = "score" + i;
			String name = "name" + i;
			storage.setNumber(score, scores[i]);
			storage.setString(name, names[i]);
		}
		try {
			storage.save();
		} catch (IOException e) {
			Log.error(e);
			return false;
		}
		return true;
	}
	
	public void dumpHighScores() {
		Log.debug("Highscores:");
		for (int i = 0; i < MAX_ENTRIES; i++) {
			Log.debug("" + i + ": score of " + scores[i] + " by " + names[i]);
		}
	}
	
}
