package net.haaks.spidertrap;

import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Circle;
import org.newdawn.slick.geom.Vector2f;

public class Guardian extends AbstractEntity {

	private static SpriteSheet guardianImages = null;

	private static final int BOUNDSRADIUS = 14;

	private int turnDirection = LEFT;
	private int direction = LEFT;
	private boolean moving = false;
	private int nextStep = 0;
	private final int NEXTSTEP = 20;	// in milliseconds
	private int SPEED = 2;
	private int[] sheetIndices = {6, 0, 2, 4};  // UP, RIGHT, DOWN, LEFT
	private boolean turning = false;	// if true guard turns to a new direction
	private int nextTurn = 0;
	private final int NEXTTURN = 100;	// in milliseconds
	private int turnInc = 0;			// either 1 or -1, depending on direction of turn
	private int sheetIndex = 0;
	private int targetSheetIndex = sheetIndices[LEFT];

	public static Guardian AddGuardian(AreaMap map, Vector2f pos, int direction, GameContext context) throws SlickException {
		//Log.debug("Guardian.AddGuardian() is called with pos " + pos.toString() + " and direction " + AbstractEntity.StringFromDirection(direction));
		Guardian guard;
		CollisionGroup cg = CollisionGroup.GetGroup("guards");
		
		if (guardianImages == null) {
			guardianImages = RessourceManager.getSpriteSheet("guardian");
		}
		guard = new Guardian(pos);
		guard.gameContext = context;
		map.addEntity(guard, AreaMap.OBJECTLAYER);
		guard.cg = cg;
		if (cg != null)
			guard.cg.add(guard);
		guard.direction = direction;
		guard.turnDirection = direction; // do we always turn left or right
		guard.sheetIndex = guard.sheetIndices[direction];
		return guard;
	}
	
	public Guardian(Vector2f startTile) {
		x = (int)startTile.x * SpiderTrap.TILESIZE;
		y = (int)startTile.y * SpiderTrap.TILESIZE;
		
		bounds = new Circle(x+SpiderTrap.TILESIZE_HALF, y+SpiderTrap.TILESIZE_HALF, BOUNDSRADIUS);
		offsetBoundsX = SpiderTrap.TILESIZE_HALF - BOUNDSRADIUS;
		offsetBoundsY = SpiderTrap.TILESIZE_HALF - BOUNDSRADIUS;
		moving = false;
		tile = startTile;
		toTile = null;		
	}

	public int getDirection() {
		return direction;
	}

	public void setDirection(int targetDirection) {
		this.targetSheetIndex = sheetIndices[targetDirection];
		if (this.targetSheetIndex != this.sheetIndex) {
			this.turning = true;
			if (targetDirection > direction)
				turnInc = 1;
			else
				turnInc = -1;
			direction = targetDirection;
		}
	}
	

	public void draw(Graphics g) {
		guardianImages.getSprite(sheetIndex, 0).draw(x, y);
//		g.setColor(Color.red);
//		g.draw(bounds);
		/*
		*/
	}

	public Circle getBounds() {
		return bounds;
	}

	public Entity getOwner() {
		return this;
	}

	public boolean hitBy(Entity source) {
		return false;
	}

	public void setMap(AreaMap map) {
		this.map = map;
	}

	public void update(int delta) {
		String[] collGroups = {"guards"};
		int xoff = 0, yoff = 0;
		if (!moving) {
			switch (direction) {
			case UP: yoff = -1; break;
			case DOWN: yoff = 1; break;
			case LEFT: xoff = -1; break;
			case RIGHT: xoff = 1; break;
			}
			Vector2f testPos = new Vector2f(tile.x+xoff, tile.y+yoff);
			if (!map.isPositionFree(collGroups, testPos))
				direction = nextDirection();
			else {
				toTile = testPos;
				switch (direction) {
				case UP:
					dx = 0; dy = -SPEED; break;
				case DOWN:
					dx = 0; dy = SPEED; break;
				case RIGHT:
					dx = SPEED; dy = 0; break;
				case LEFT:
					dx = -SPEED; dy = 0; break;
				}
				moving = true;
				targetSheetIndex = sheetIndices[direction];
			}
		}
		if (turning) {
			nextTurn += delta;
			if (nextTurn > NEXTTURN) {
				nextTurn -= NEXTTURN;
				if (sheetIndex != targetSheetIndex) {
					sheetIndex -= turnInc;
					if (sheetIndex < 0)
						sheetIndex = 7;
					if (sheetIndex > 7)
						sheetIndex = 0;
					if (sheetIndex == targetSheetIndex) {
						nextTurn = 0;
						turning = false;
					}
				}
			}
		}
		if (moving) {
			// move til we fit the tile perfectly
			nextStep += delta;
			if (nextStep >= NEXTSTEP) {
				x += dx;
				y += dy;
				nextStep -= NEXTSTEP;
				if (x % SpiderTrap.TILESIZE == 0 && y % SpiderTrap.TILESIZE == 0) {
					// reached the next tile. stop moving.
					moving = false;
					tile = toTile; toTile = null;
					nextStep = 0;
				}
			}
			bounds.setX(x+offsetBoundsX);
			bounds.setY(y+offsetBoundsY);
		}
	}
	
	private int nextDirection() {
		// private int[] sheetIndices = {4, 2, 0, 6};  // UP, RIGHT, DOWN, LEFT
		turning = true;
		if (turnDirection == LEFT) {
			turnInc = 1;
			switch (direction) {
			case UP: return LEFT;
			case RIGHT: return UP;
			case DOWN: return RIGHT;
			case LEFT: return DOWN;
			}
		} else {
			turnInc = -1;
			switch (direction) {
			case UP: return RIGHT;
			case RIGHT: return DOWN;
			case DOWN: return LEFT;
			case LEFT: return UP; 
			}
		}
		// not reached
		return LEFT;
	}

}
