package net.haaks.spidertrap;

import java.io.IOException;

import org.newdawn.slick.SavedState;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.util.Log;

public class GameOptions {
	private static GameOptions options = null;

	private static String saveName = "SpiderTrapOptions";

	private float sfxVolume = 1.0f;

	private float musicVolume = 1.0f;

	private boolean skipTutorials = false;

	private SavedState storage = null;

	private GameOptions() {

	}

	/**
	 * the public getter for the singleton GameOptions
	 * 
	 * @return the GameOptions singleton
	 */
	public static GameOptions get() {
		if (options == null) {
			options = new GameOptions();
			// try to load existing options
			try {
				options.storage = new SavedState(saveName);
			} catch (SlickException e) {
				Log.error(e);
			}
			if (options.storage != null) {
				boolean retval = options.load();
				if (!retval)
					Log.debug("GameOptions.get(): could not load game options...");
			}
		}
		return options;
	}

	private boolean load() {
		try {
			storage.load();
		} catch (IOException e) {
			Log.error("Loading game options failed");
			Log.error(e);
		}
		// put loaded values into singleton
		this.musicVolume = (float) storage.getNumber("musicvolume");
		Log.debug("GameOptions.load(): music volume is " + this.musicVolume);
		this.sfxVolume = (float) storage.getNumber("sfxvolume");
		Log.debug("GameOptions.load(): sfx volume is " + this.sfxVolume);
		String tutorials = storage.getString("skiptutorials");
		Log.debug("GameOptions.load(): tutorials is " + tutorials);
		this.skipTutorials = Boolean.parseBoolean(tutorials);
		Log.debug("GameOptions.load(): skip tutorials is " + ((this.skipTutorials)?"true":"false"));
		return true;
	}

	public boolean save() {
		storage.setNumber("musicvolume", (double) musicVolume);
		storage.setNumber("sfxvolume", (double) sfxVolume);
		storage.setString("skiptutorials", Boolean.toString(skipTutorials));
		try {
			storage.save();
		} catch (IOException e) {
			Log.error(e);
			return false;
		}
		return true;
	}

	public float getMusicVolume() {
		return musicVolume;
	}

	public void setMusicVolume(float musicVolume) {
		this.musicVolume = musicVolume;
	}

	public boolean isSkipTutorials() {
		return skipTutorials;
	}

	public void setSkipTutorials(boolean skipTutorials) {
		this.skipTutorials = skipTutorials;
	}

	public float getSfxVolume() {
		return sfxVolume;
	}

	public void setSfxVolume(float soundVolume) {
		this.sfxVolume = soundVolume;
	}

}
