package net.haaks.spidertrap;

import java.util.ArrayList;

import org.newdawn.slick.Graphics;

public class FloatingTextBonusEmitter {
	private ArrayList<FloatingTextBonus> texts = new ArrayList<FloatingTextBonus>();
	private ArrayList<FloatingTextBonus> toBeRemoved = new ArrayList<FloatingTextBonus>();
	
	public void add(FloatingTextBonus bonus) {
		if (bonus != null)
			texts.add(bonus);
	}
	
	public void updateSystem(int delta) {
		if (texts == null || texts.size() == 0)
			return;
		for (FloatingTextBonus bonus : texts) {
			bonus.update(delta);
		}
		texts.removeAll(toBeRemoved);
		toBeRemoved.clear();
	}

	public void renderSystem(Graphics g) {
		if (texts == null || texts.size() == 0)
			return;
		for (FloatingTextBonus bonus : texts) {
			bonus.render(g);
		}
	}
	
	public void removeMe(FloatingTextBonus bonus) {
		toBeRemoved.add(bonus);
	}
	
	
}
