package net.haaks.spidertrap;

import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.Graphics;

public class FloatingTextBonus {
	
	private String text;
	private Font font;
	private int speedY;
	private int speedDelta;
	private int maxAliveMS;
	private int aliveMS;
	private int curDelta;
	private FloatingTextBonusEmitter emitter;
	private float alpha;
	private int x, y;
	private float alphaDec;
	private Color col;

	public FloatingTextBonus(FloatingTextBonusEmitter emitter, String text, AngelCodeFont font, int x, int y, int speedY, int speedDelta, int maxAliveMS, float alphaDec) {
		this.emitter = emitter;
		this.text = text;
		this.font = font;
		this.speedY = speedY;
		this.speedDelta = speedDelta;
		this.maxAliveMS = maxAliveMS;
		this.x = x;
		this.y = y;
		this.aliveMS = 0;
		this.curDelta = 0;
		this.alpha = 1.0f;
		this.alphaDec = alphaDec;
		this.col = new Color(1.0f, 1.0f,1.0f,1.0f);
	}

	public void update(int delta) {
		aliveMS += delta;
		curDelta += delta;
		if (aliveMS > maxAliveMS)
			emitter.removeMe(this);
		if (curDelta > speedDelta) {
			this.y -= speedY;
			curDelta -= speedDelta;
			alpha -= alphaDec;
			col.a = (float) alpha;
		}
		if (y + font.getHeight(text) < 0 || alpha < 0.0)
			emitter.removeMe(this);
	}

	public void render(Graphics g) {
		g.setColor(col);
		g.setFont(font);
		g.drawString(text, x, y);
	}

}
