package net.haaks.spidertrap;

import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Circle;
import org.newdawn.slick.geom.Vector2f;

/**
 * Interface for all entities
 *
 * @author Tommy
 */
public interface Entity {

	public void setMap(AreaMap map);
	
	public boolean isBlocked(Vector2f tile);
	
	public boolean isBlocked(Entity source);
	
	public void draw(Graphics g);
	
	public void update(int delta);
	
	public Circle getBounds();
	
	public Entity getOwner();
	
	/**
	 * boolean hitBy(Entity source)
	 * @param source the entity that we collided with.
	 * @return true if we need to be removed from the collision group, false otherwise
	 */
	public boolean hitBy(Entity source);
	
	public int getX();
	
	public int getY();
	
}
