package net.haaks.spidertrap;

import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Circle;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.util.Log;

public class EnergySucker extends AbstractEntity {

	private static final int BOUNDSRADIUS = 14;

	private static SpriteSheet suckerImages = null;
	
	private static Color transparent = new Color (255, 255, 255, 192);

	private int direction = LEFT;

	private boolean moving = false;

	private int nextStep = 0;

	private final int NEXTSTEP = 20; // in milliseconds

	private int SPEED = 2;

	private int sheetIndex = 0;
	
	private long sucktime = 0;
	private long SUCK_EVERY_MILLIS = 100;

	public EnergySucker(Vector2f startTile) {
		x = (int) startTile.x * SpiderTrap.TILESIZE;
		y = (int) startTile.y * SpiderTrap.TILESIZE;

		bounds = new Circle(x+SpiderTrap.TILESIZE_HALF, y+SpiderTrap.TILESIZE_HALF, BOUNDSRADIUS);
		offsetBoundsX = SpiderTrap.TILESIZE_HALF - BOUNDSRADIUS;
		offsetBoundsY = SpiderTrap.TILESIZE_HALF - BOUNDSRADIUS;
		moving = false;
		tile = startTile;
		toTile = null;
	}

	public static EnergySucker AddEnergySucker(AreaMap map, Vector2f pos,
			int direction, GameContext context) throws SlickException {
//		Log.debug("EnergySucker.AddEnergySucker() is called with pos "
//				+ pos.toString() + " and direction "
//				+ AbstractEntity.StringFromDirection(direction));
		EnergySucker sucker;
		CollisionGroup cg = CollisionGroup.GetGroup("sucker");

		if (suckerImages == null)
			suckerImages = RessourceManager.getSpriteSheet("sucker");
		sucker = new EnergySucker(pos);
		sucker.gameContext = context;
		map.addEntity(sucker, AreaMap.OBJECTLAYER);
		sucker.cg = cg;
		if (cg != null)
			sucker.cg.add(sucker);
		sucker.direction = direction;
		sucker.sheetIndex = 0;
		return sucker;
	}

	public void draw(Graphics g) {
		suckerImages.getSprite(sheetIndex, 0).draw(x, y, transparent);
//		g.setColor(Color.red);
//		g.draw(bounds);
		/*
		*/
	}

	public Circle getBounds() {
		return bounds;
	}

	public Entity getOwner() {
		return this;
	}

	public boolean hitBy(Entity source) {
		// nobody destroys a sucker ;-)
		if (source instanceof Robot) {
//			Log.debug("collision with robot");
			long collisiontime = System.currentTimeMillis(); 
			if (sucktime == 0)
				sucktime = collisiontime;
			if (collisiontime - sucktime > SUCK_EVERY_MILLIS) {
				gameContext.propagate(GameContext.ENERGYSUCKED, null, null, null, null);
				sucktime = 0;
			}
			return false;
		}
		return false;
	}

	public void setMap(AreaMap map) {
		this.map = map;
	}

	public void update(int delta) {
		int xoff = 0, yoff = 0;
		if (!moving) {
			switch (direction) {
			case UP:
				yoff = -1;
				break;
			case DOWN:
				yoff = 1;
				break;
			case LEFT:
				xoff = -1;
				break;
			case RIGHT:
				xoff = 1;
				break;
			}
			Vector2f testPos = new Vector2f(tile.x + xoff, tile.y + yoff);
			if (!map.isPositionFree(null, testPos))
				direction = nextDirection();
			else {
				toTile = testPos;
				switch (direction) {
				case UP:
					dx = 0;
					dy = -SPEED;
					break;
				case DOWN:
					dx = 0;
					dy = SPEED;
					break;
				case RIGHT:
					dx = SPEED;
					dy = 0;
					break;
				case LEFT:
					dx = -SPEED;
					dy = 0;
					break;
				}
				moving = true;
			}
		}
		if (moving) {
			// move til we fit the tile perfectly
			nextStep += delta;
			if (nextStep >= NEXTSTEP) {
				x += dx;
				y += dy;
				nextStep -= NEXTSTEP;
				sheetIndex += 1;
				if (sheetIndex > 7)
					sheetIndex = 0;
				if (x % SpiderTrap.TILESIZE == 0
						&& y % SpiderTrap.TILESIZE == 0) {
					// reached the next tile. stop moving.
					moving = false;
					tile = toTile;
					toTile = null;
					nextStep = 0;
				}
			}
			bounds.setX(x + offsetBoundsX);
			bounds.setY(y + offsetBoundsY);
		}
	}

	private int nextDirection() {
		switch (direction) {
		case UP:
			return DOWN;
		case DOWN:
			return UP;
		case RIGHT:
			return LEFT;
		case LEFT:
			return RIGHT;
		}
		// not reached
		return LEFT;
	}
}
