package net.haaks.spidertrap;

import org.newdawn.slick.Graphics;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Circle;
import org.newdawn.slick.geom.Vector2f;

public class EggSplat extends AbstractEntity implements Entity {

	private static SpriteSheet splatImages = null;
	private int phase = 7;	// first image of egg in eggbroken.png
	private int timer = 0;
	private static final int NEXTPHASE = 2000;
	private static final int LASTPHASE = 0;

	public static EggSplat AddEggSplat(AreaMap map, Vector2f pos, GameContext context) {
		EggSplat eggSplat;
		
		if (splatImages == null)
			splatImages = RessourceManager.getSpriteSheet("eggbroken");
		eggSplat = new EggSplat(pos);
		eggSplat.gameContext = context;
		map.addEntity(eggSplat, AreaMap.GROUNDLAYER);
		return eggSplat;
		
	}
	
	public EggSplat(Vector2f startTile) {
		x = (int)startTile.x * SpiderTrap.TILESIZE;
		y = (int)startTile.y * SpiderTrap.TILESIZE;
		
		bounds = null;
		tile = startTile;
		toTile = null;
	}

	public void draw(Graphics g) {
		splatImages.getSprite(phase, 0).draw(x, y);
	}

	public Circle getBounds() {
		return null;
	}

	public Entity getOwner() {
		return this;
	}

	public boolean hitBy(Entity source) {
		return false;
	}

	public void setMap(AreaMap map) {
		this.map = map;
	}

	public void update(int delta) {
		timer += delta;
		if (timer > NEXTPHASE) {
			phase--;
			timer -= NEXTPHASE;
		}
		if (phase < LASTPHASE) {
			// remove from map
			map.removeEntity(this);
		}
	}

}
