package net.haaks.spidertrap;

import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Circle;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.util.Log;

public class Egg extends AbstractEntity implements Entity {

	private static SpriteSheet eggImages = null;
	private int phase = 0;	// first image of egg in egg.png, last one is 7
	private int timer = 0;
	private static final int NEXTPHASE = 2000;
	private static final int LASTPHASE = 7;
	
	private static final int BOUNDSRADIUS = 14;
	
	private boolean done = false;

	public static Egg AddEgg(AreaMap map, Vector2f pos, CollisionGroup cg, GameContext context) {
		Egg egg;
		
		if (eggImages == null)
			eggImages = RessourceManager.getSpriteSheet("egg");
		egg = new Egg(pos);
		egg.gameContext = context;
		map.addEntity(egg, AreaMap.GROUNDLAYER);
		egg.cg = cg;
		if (cg != null)
			egg.cg.add(egg);
		return egg;
		
	}
	
	public Egg(Vector2f startTile) {
		x = (int)startTile.x * SpiderTrap.TILESIZE;
		y = (int)startTile.y * SpiderTrap.TILESIZE;
		
		bounds = new Circle(x+SpiderTrap.TILESIZE_HALF, y+SpiderTrap.TILESIZE_HALF, BOUNDSRADIUS);
		offsetBoundsX = SpiderTrap.TILESIZE_HALF - BOUNDSRADIUS;
		offsetBoundsY = SpiderTrap.TILESIZE_HALF - BOUNDSRADIUS;
		tile = startTile;
		toTile = null;
	}

	public void draw(Graphics g) {
		eggImages.getSprite(phase, 0).draw(x, y);
//		g.setColor(Color.red);
//		g.draw(bounds);
	}

	public Circle getBounds() {
		return bounds;
	}

	public Entity getOwner() {
		return this;
	}

	public boolean hitBy(Entity source) {
		// collisions with balls. They destroy us.
		if (source instanceof Robot) {
			gameContext.propagate(GameContext.EGGDESTROYED, tile, null, null, null);
			map.removeEntity(this);
			done = true;
			map.addEggSplash(this.tile);
			return true; // remove us from our collision group
		}
		return false;
	}

	public void setMap(AreaMap map) {
		this.map = map;
	}

	public void update(int delta) {
		if (done)
			return;
		
		timer += delta;
		if (timer > NEXTPHASE) {
			phase++;
			timer -= NEXTPHASE;
		}
		if (phase > LASTPHASE) {
			// we need to replace ourselves with a new spider
			cg.markForRemove(this);
			map.removeEntity(this);
			Spider.AddSpider(map, tile, CollisionGroup.GetGroup("spiders"), gameContext);
			done = true;
		}
	}

}
