package net.haaks.spidertrap;

import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Input;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;
import org.newdawn.slick.util.Log;

public class CreditsState extends BasicGameState implements GameContext {

	private Font bigFont, smallFont;
	private TextScroller titleText = null, creditsText = null;
	
	private String[] title = { "Credits" };
	
	private String[] credits = {
		"",
		"Kevin Glass (www.slick.cokeandcode.com)",
		"for creating Slick, the 2D Java game lib,",
		"Cinfa (www.bottomap.com)",
		"for the graphics in this game,",
		"www.modplugarchive.com and",
		"baroque of freelance for the music,",
		"www.flashkit.com/soundfx for some sounds,",
		"Niels and Juergen for keeping me motivated.",
		"",
		"Press Space for tools, Escape for main menu"
	};
	
	private String[] tools = {
		"",
		"Tools used:",
		"Java 5, Eclipse, TileStudio, CB Model Pro,",
		"Hiero & Pedigree (Slick), LithUnwrap,",
		"SpriteForge, Slashstone SFXBuilder,",
		"Wings3D, Blender, pngout, GlueIt",
		"",
		"",
		"",
		"",
		"Press Space for credits, Escape for main menu"
	};

	private String[] text;
	
	/** The game holding this state */
	private StateBasedGame myGame;
	private GameContainer myContainer;

	// graphics and sound stuff
	private Music music = null;

	private AreaMap map;	// the map for the background
	
	private CollisionGroup cgCredits = null;
	private CollisionManager cgManager = CollisionManager.getSingleton();

	@Override
	public int getID() {
		return SpiderTrap.CREDITS_STATE;
	}

	public void init(GameContainer container, StateBasedGame game) throws SlickException {
		SpiderTrap.initRessources();
		
//		bigFont = RessourceManager.getAngelCodeFont("info");
		bigFont = RessourceManager.getAngelCodeFont("orangeinfo");
		smallFont = RessourceManager.getAngelCodeFont("hud");
		this.myGame = game;
		this.myContainer = container;

		music = RessourceManager.getMusic("titlemusic");
		
		map = new AreaMap(this, "res/title.tmx");
		// center camera on map
		Vector2f center = new Vector2f(SpiderTrap.WIDTH_HALF, SpiderTrap.HEIGHT_HALF);
		map.setFocusObj(new SimpleMapFocus(center));
		map.setCameraStart(center);
		cgCredits = CollisionGroup.GetGroup("spiders");

		text = credits;
	}

	public void enter(GameContainer container, StateBasedGame game) throws SlickException {
		Log.debug("CreditsState.enter() is called");

		map.removeAllSpidersAndEggs();
		cgManager .clearAllCollisionGroups();
		Vector2f freepos = map.getFreePosition();
		Spider.AddSpider(map, freepos, cgCredits, this);

		titleText = new TextScroller(title, bigFont, Color.white, TextScroller.FORMAT_CENTER,
				0, 10, TextScroller.MOVE_UP, 20, 2);
		creditsText = new TextScroller(text, smallFont, Color.white, TextScroller.FORMAT_CENTER,
				0, 40, TextScroller.MOVE_UP, 25, 2);
		if (!music.playing())
			music.loop();
	}

	public void leave(GameContainer container, StateBasedGame game) throws SlickException {
		Log.debug("CreditsState.leave() is called");
		cgCredits.clear();
	}

	public void propagate(int notification, Vector2f tile, String infoString, Integer infoInt, Double infoDouble) {
		// we do nothing here; simply here to use spiders on the title screen 
	}

	public void render(GameContainer container, StateBasedGame game, Graphics g)
			throws SlickException {
		if (map != null) {
			map.draw(g);
		}
		if (titleText != null)
			titleText.render(g);
		if (creditsText != null)
			creditsText.render(g);
	}

	public void update(GameContainer container, StateBasedGame game, int delta)
			throws SlickException {
		map.update(delta);
		cgManager.update();
		titleText.update(delta);
		creditsText.update(delta);
	}

	public void keyReleased(int key, char c) {
		if (key == Input.KEY_SPACE) {
			if (text == credits)
				text = tools;
			else
				text = credits;
			creditsText = new TextScroller(text, smallFont, Color.white, TextScroller.FORMAT_CENTER,
					5, 40, TextScroller.MOVE_UP, 25, 2);
			
		}
		if (key == Input.KEY_ESCAPE) {
			// back to title menu
			myGame.enterState(SpiderTrap.TITLE_STATE, new FadeOutTransition(Color.black),
					new FadeInTransition(Color.black));
		}
	}

}
