package net.haaks.spidertrap;

import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Circle;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.particles.ConfigurableEmitter;

public class Computer extends AbstractEntity implements Entity {

	private static SpriteSheet shieldImages = null;
	private static Sound explosion = null;

	private static final int IMAGECHANGEMS = 100;
	private static final float ALPHA = 0.5f;

	private Color col = new Color(1.0f, 1.0f, 1.0f, ALPHA);
	private ConfigurableEmitter explEmitter = null;
	
	private int ms = 0;
	private int sheetIndex = 0;
	private boolean shieldsDown = false;
	private boolean kaboom = false;
	
	public static Computer AddComputer(AreaMap map, Vector2f pos, ConfigurableEmitter emitter, CollisionGroup cg, GameContext context) {
		Computer compi;
		
		if (shieldImages == null) {
			shieldImages = RessourceManager.getSpriteSheet("shield");
			explosion = RessourceManager.getSound("computerexplosion");
		}

		compi = new Computer(pos);
		compi.gameContext = context;
		map.addEntity(compi, AreaMap.OBJECTLAYER);
		compi.cg = cg;
		compi.explEmitter = emitter;
		if (cg != null)
			cg.add(compi);
		return compi;
		
	}
	
	public Computer(Vector2f startTile) {
		x = (int)startTile.x * SpiderTrap.TILESIZE;
		y = (int)startTile.y * SpiderTrap.TILESIZE;
		
		bounds = new Circle(x+16, y+16, 15);
		tile = startTile;
		toTile = null;
	}
	
	public void draw(Graphics g) {
		if (!shieldsDown) {
			shieldImages.getSprite(sheetIndex, 0).draw(x, y, col);
		}
	}

	public Circle getBounds() {
		return bounds;
	}

	public Entity getOwner() {
		return this;
	}

	public boolean hitBy(Entity source) {
		// if we are hit by anything -> explosion and game over
		gameContext.propagate(GameContext.ANYTHINGHITCOMPUTER, tile, null, null, null);
		return false;
	}

	public void setMap(AreaMap map) {
		this.map = map;
	}

	public void setShieldsDown() {
		shieldsDown = true;
		map.setBlocked((int)tile.x, (int)tile.y, false);
	}
	
	public void goKaboom() {
		kaboom = true;
		explEmitter.setEnabled(true);
		explosion.play();
	}
	
	public void update(int delta) {
		if (shieldsDown)
			return;
		// still draw the shield
		ms += delta;
		if (ms > IMAGECHANGEMS) {
			ms -= IMAGECHANGEMS;
			sheetIndex ++;
			if (sheetIndex > 15)
				sheetIndex = 0;
		}
	}
}
