package net.haaks.spidertrap;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

/**
 * A singleton
 * @author Tommy
 *
 */
public class CollisionManager {
	private static CollisionManager singleton = null;
	
	private ArrayList tupels = new ArrayList();
	
	public static CollisionManager getSingleton() {
		if (singleton == null)
			singleton = new CollisionManager();
		return singleton;
	}
	
	private CollisionManager() {};
	
	public void addCollisionTupel(CollisionGroup one, CollisionGroup two) {
		if (one != null && two != null) {
			ArrayList aTupel = new ArrayList();
			aTupel.add(one);
			aTupel.add(two);
			tupels.add(aTupel);
		}
	}
	
	public void update() {
		Iterator iter = tupels.iterator();
		
		while (iter.hasNext()) {
			ArrayList tupel = (ArrayList) iter.next();
			CollisionGroup cgOne = (CollisionGroup) tupel.get(0);
			CollisionGroup cgTwo = (CollisionGroup) tupel.get(1);
			ArrayList one = cgOne.getElements();
			ArrayList two = cgTwo.getElements();
			// now check each item of one against each item of two
			for (int i = 0; i < one.size(); i++) {
				Entity a = (Entity) one.get(i);
				if (!cgOne.isMarkedForRemove(a)) {
					for (int j = 0; j < two.size(); j++) {
						Entity b = (Entity) two.get(j);
						if (!cgTwo.isMarkedForRemove(b)) {
							if (a != b) {
								if (a.isBlocked(b)) {
									boolean removeA = a.hitBy(b);
									boolean removeB = b.hitBy(a);
									if (removeA)
										cgOne.markForRemove(a);
									if (removeB)
										cgTwo.markForRemove(b);
								}
							}
						}
					}
				}
			}
		}
		clearCollisionGroupRemovals();
	}


	
	private void clearCollisionGroupRemovals() {
		Hashtable all = CollisionGroup.GetAllGroups();
		Enumeration cgs = all.elements();
		while (cgs.hasMoreElements()) {
			CollisionGroup cg = (CollisionGroup) cgs.nextElement();
			cg.removeMarkedOnes();
		}
	}
	
	public void clearAllCollisionGroups() {
		// just a delegate
		CollisionGroup.ClearAllGroups();
	}

}
