package net.haaks.spidertrap;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

import org.newdawn.slick.util.Log;

public class CollisionGroup {
	private ArrayList elems = new ArrayList();
	private ArrayList removeUs = new ArrayList();
	private String name = null;
	private int id;
	
	private static Hashtable AllGroups = new Hashtable();
	private static int nextid = 1;

	public static CollisionGroup GetGroup(String name) {
		CollisionGroup theOne = (CollisionGroup)AllGroups.get(name);
		if (theOne == null) {
			theOne = new CollisionGroup(name);
			//Log.debug("CollisionGroup.GetGroup("+name+"): create new group " + theOne.toString());
		} else {
			//Log.debug("CollisionGroup.GetGroup("+name+"): return existing group " + theOne.toString());
		}
		return theOne;
	}
	
	public static Hashtable GetAllGroups() {
		return AllGroups;
	}
	
	public static void ClearAllGroups() {
		Hashtable all = CollisionGroup.GetAllGroups();
		Enumeration cgs = all.elements();
		while (cgs.hasMoreElements()) {
			CollisionGroup cg = (CollisionGroup) cgs.nextElement();
			cg.clear();
		}
	}
	
	private CollisionGroup(String name) {
		this.name = name;
		this.id = nextid;
		nextid++;
		AllGroups.put(name, this);
	}
	
	public ArrayList getElements() {
		return elems;
	}
	
	public void clear() {
		elems = new ArrayList();
	}
	
	public void add(Entity element) {
		if (element != null)
			elems.add(element);
	}
	
	public void markForRemove(Entity element) {
		if (element != null)
			removeUs.add(element);
	}
	
	public boolean isMarkedForRemove(Entity element) {
		return removeUs.contains(element);
	}
	
	public void removeMarkedOnes() {
		Iterator iter = removeUs.iterator();
		
		while (iter.hasNext()) {
			Entity elem = (Entity) iter.next();
			if (elems.contains(elem)) {
				elems.remove(elem);
//				Log.debug("CG '" + name + "': removing " + elem);
			}
		}
		removeUs = new ArrayList();
	}
	
	public String toString() {
		return ("CollisionGroup '" + name + "', id=" + id + ", elements: <" + elems.toString() + ">");
	}

}
