package net.haaks.spidertrap;

import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.geom.Circle;
import org.newdawn.slick.geom.Vector2f;

public class Bullet extends AbstractEntity implements Entity {

	private static int PARTICLE_TIME = 2;
	private static int MOVE_TIME = 10;
	private static int LESS = 0;
	private static int MORE = 1;

	private static final int BOUNDSRADIUS = 6;

	private int direction = NODIR;
	private int lastx = -1, lasty = -1;
	private int lessOrMore;
	private int nextParticle = 0;
	private int speed = 4;
	private int nextMove = 0;
	
	public static Bullet AddBullet(AreaMap map, Vector2f pos, CollisionGroup cg, GameContext context, int direction) {
		Bullet bullet;
		bullet = new Bullet(pos, direction);
		bullet.gameContext = context;
		map.addEntity(bullet, AreaMap.OBJECTLAYER);
		bullet.cg = cg;
		if (cg != null)
			bullet.cg.add(bullet);
		bullet.setLastXY(pos, direction);
		return bullet;
	}
	
	public Bullet(Vector2f startTile, int direction) {
		x = (int)startTile.x * SpiderTrap.TILESIZE;
		y = (int)startTile.y * SpiderTrap.TILESIZE;
		
		// due to perspective reasons horizontal shots need to start a few pixels above
		if (direction == LEFT || direction == RIGHT)
			y -= 6;
		this.direction = direction;
		bounds = new Circle(x+SpiderTrap.TILESIZE_HALF, y+SpiderTrap.TILESIZE_HALF, BOUNDSRADIUS);
		offsetBoundsX = SpiderTrap.TILESIZE_HALF - BOUNDSRADIUS;
		offsetBoundsY = SpiderTrap.TILESIZE_HALF - BOUNDSRADIUS;
		tile = startTile;
		switch (direction) {
		case UP:
			dx = 0; dy = -speed; break;
		case DOWN:
			dx = 0; dy = speed; break;
		case RIGHT:
			dx = speed; dy = 0; break;
		case LEFT:
			dx = -speed; dy = 0; break;
		}
	}

	private void setLastXY(Vector2f startTile, int dir) {
		int tilex = 0, tiley = 0, offsetx = 0, offsety = 0;
		switch (direction) {
		case UP:
			tiley = -1; lessOrMore = LESS; offsety = -(SpiderTrap.TILESIZE_HALF - 1); break;
		case DOWN:
			tiley = 1; lessOrMore = MORE; offsety = SpiderTrap.TILESIZE_HALF - 1; break;
		case RIGHT:
			tilex = 1; lessOrMore = MORE; offsetx = SpiderTrap.TILESIZE_HALF - 1; break;
		case LEFT:
			tilex = -1; lessOrMore = LESS; offsetx = -(SpiderTrap.TILESIZE_HALF - 1); break;
		}
		Vector2f freeTile = new Vector2f(startTile.x, startTile.y);
		Vector2f testTile = new Vector2f(freeTile.x + tilex, freeTile.y + tiley);
		while (map.isPositionFree(testTile, null)) {
			freeTile.x += tilex; freeTile.y += tiley;
			testTile.x += tilex; testTile.y += tiley;
		}
		// now freeTile contains the last free tile, testTile contains the blocked tile
		lastx = (int) (freeTile.x * SpiderTrap.TILESIZE + offsetx);
		lasty = (int) (freeTile.y * SpiderTrap.TILESIZE + offsety);
		if (direction == LEFT || direction == RIGHT)
			lasty -= 6;
		
//		Log.debug("Bullet.setLastXY: lastx = " + lastx + ", lasty = " + lasty);
		
		
	}

	public void draw(Graphics g) {
		// drawn by BulletEmitter in AreaMap
//		g.setColor(Color.red);
//		g.draw(bounds);
		/*
		*/

	}

	public Circle getBounds() {
		return bounds;
	}

	public Entity getOwner() {
		return this;
	}

	public boolean hitBy(Entity source) {
		// guardians are tough so the bullet ends there!
		if (source instanceof Guardian) {
			map.removeEntity(this);
			map.addSparks(x + SpiderTrap.TILESIZE_HALF, y + SpiderTrap.TILESIZE_HALF);
			return true;
		}
		return false;
	}

	public void setMap(AreaMap map) {
		this.map = map;
	}

	public void update(int delta) {
		nextParticle += delta;
		while (nextParticle > PARTICLE_TIME) {
			nextParticle -= PARTICLE_TIME;
			map.addBulletParticle(x + SpiderTrap.TILESIZE_HALF, y + SpiderTrap.TILESIZE_HALF);
		}
		// handle the movement
//		if (!map.isPositionFree(null, tile)) {
		if (((lessOrMore==MORE) && (x > lastx || y > lasty)) || 
				((lessOrMore==LESS) && (x < lastx || y < lasty))) {
			// remove this bullet from map and collisiongroup
			map.removeEntity(this);
			cg.markForRemove(this);
			map.addSparks(x + SpiderTrap.TILESIZE_HALF, y + SpiderTrap.TILESIZE_HALF);
//			Log.debug("Bullet.update(): removed bullet " + this.toString() + " at x=" + x + ", y=" + y);
		}
		nextMove += delta;
		if (nextMove >= MOVE_TIME) {
			nextMove -= MOVE_TIME;
			x += dx;
			y += dy;
		}
		if (x % SpiderTrap.TILESIZE == 0 && y % SpiderTrap.TILESIZE == 0) {
			// reached the next tile. update tile
			Vector2f newTile = new Vector2f(tile.x + Math.signum(dx), tile.y + Math.signum(dy));
			tile = newTile;
		}
		bounds.setX(x + offsetBoundsX);
		bounds.setY(y + offsetBoundsY);
	}

}
