package net.haaks.spidertrap;

import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.geom.Circle;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.util.Log;

public class Bonus extends AbstractEntity {
	
	public static final int TIME = 0;
	public static final int ENERGY = 1;
	
	private static final int BOUNDSRADIUS = 14;
	
	private static SpriteSheet timeBonus = null, energyBonus = null;
	private static int APPEARANCE = 5000;		// how long is the bonus on screen
	private static Sound bonusSound;
	
	private boolean onScreen = false;
	private SpriteSheet currentSheet = null;
	private int sheetIndex = 0;
	private int timer = 0;
	private int bonusType = TIME;
	private int nextanim = 0;
	private final int NEXTANIM = 100;	// in milliseconds

	public static Bonus AddBonus(AreaMap map, GameContext context, boolean onscreen) throws SlickException {
		Bonus bonus;
		CollisionGroup cg = CollisionGroup.GetGroup("boni");
		
		if (timeBonus == null) {
			timeBonus = RessourceManager.getSpriteSheet("clock");
			energyBonus = RessourceManager.getSpriteSheet("battery");
		}
		bonusSound = RessourceManager.getSound("bonus2");
		bonus = new Bonus();
		bonus.gameContext = context;
		map.addEntity(bonus, AreaMap.OBJECTLAYER);
		bonus.cg = cg;
		if (cg != null)
			bonus.cg.add(bonus);
		bonus.setRandomPositionAndType();
		bonus.sheetIndex = 0;
		bonus.onScreen = onscreen;
		bonus.timer = 0;
		return bonus;
	}
	
	private void setRandomPositionAndType() {
		Vector2f startTile = map.getFreePosition();
		
		x = (int)startTile.x * SpiderTrap.TILESIZE;
		y = (int)startTile.y * SpiderTrap.TILESIZE;
		
		bounds = new Circle(x+SpiderTrap.TILESIZE_HALF, y+SpiderTrap.TILESIZE_HALF, BOUNDSRADIUS);
		offsetBoundsX = SpiderTrap.TILESIZE_HALF - BOUNDSRADIUS;
		offsetBoundsY = SpiderTrap.TILESIZE_HALF - BOUNDSRADIUS;
		tile = startTile;
		toTile = null;		
		bonusType = randomValue(TIME, ENERGY);
//		Log.debug("Created new bonus of type " + bonusType);
		switch (bonusType) {
			case ENERGY: currentSheet = energyBonus; break;
			case TIME: currentSheet = timeBonus; break;
		}
		nextanim = 0;
	}
	
	public void draw(Graphics g) {
		if (!onScreen)
			return;
		currentSheet.getSprite(sheetIndex, 0).draw(x, y);
//		g.setColor(Color.red);
//		g.draw(bounds);
	}

	public Circle getBounds() {
		return bounds;
	}

	public Entity getOwner() {
		return this;
	}

	public boolean hitBy(Entity source) {
		if (!onScreen)
			return false;
		if (source instanceof Robot) {
			gameContext.propagate(GameContext.BONUSPICKEDUP, tile, null, bonusType, null);
			onScreen = false;
			timer = 0;
			bonusSound.play();
		}
		return false;
	}

	public void setMap(AreaMap map) {
		this.map = map;
	}

	public void update(int delta) {
		if (!onScreen) {
			timer += delta;
			if (timer > APPEARANCE) {
				setRandomPositionAndType();
				timer = 0;
				onScreen = true;
			}
		} else {
			// bonus on screen
			timer += delta;
			nextanim += delta;
			if (nextanim > NEXTANIM) {
				nextanim -= NEXTANIM;
				sheetIndex += 1;
				if (sheetIndex > 7)
					sheetIndex = 0;
			}
			if (timer > APPEARANCE) {
				// disappear again
				onScreen = false;
				timer = 0;
			}
		}
	}

}
