package net.haaks.spidertrap;

import java.util.Random;
import java.util.ArrayList;

import org.newdawn.slick.geom.Circle;
import org.newdawn.slick.geom.Vector2f;

/**
 * Superclass for all entities
 *
 * @author Tommy
 */
public abstract class AbstractEntity implements Entity, AreaMapFocus {
	// some statics
	public static final int NODIR = -1;
	public static final int UP = 0;
	public static final int RIGHT = 1;
	public static final int DOWN = 2;
	public static final int LEFT = 3;
	
	protected GameContext gameContext = null;
	protected AreaMap map = null;
	protected CollisionGroup cg = null;
	protected Circle bounds;
	/** used to position bounds object relative to top left of entity */
	protected int offsetBoundsX = 0;
	/** used to position bounds object relative to top left of entity */
	protected int offsetBoundsY = 0;
	protected Vector2f tile, toTile;
	protected int x, y; // absolute pixel coordinates
	protected int desiredx, desiredy; // delta for the desired directions
	protected int dx, dy; // real deltas while moving

	public void applyDirection(int deltax, int deltay) {
		desiredx = deltax;
		desiredy = deltay;
	}

	public boolean isBlocked(Vector2f tile) {
		if ((int)tile.x == (int)this.tile.x && (int)tile.y == (int)this.tile.y)
			return true;
		if (toTile != null) {
			if ((int)tile.x == (int)this.toTile.x && (int)tile.y == (int)this.toTile.y)
				return true;
		}
		return false;
	}
	
	public boolean isBlocked(Entity check) {
		if (bounds.intersects(check.getBounds()))
			return true;
		return false;
	}
	
	
	public Vector2f getTile() {
		return tile;
	}

	public Vector2f getToTile() {
		return toTile;
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}
	
	public Vector2f getPosition() {
		return new Vector2f(x, y);
	}
	
	public int randomDirection() {
		Random rndGen = new Random();
		return rndGen.nextInt(4);	// return a random between 0 and 3 (our directions)
	}

	public int randomDirectionFrom(ArrayList dirs) {
		Random rndGen = new Random();
		int index = rndGen.nextInt(dirs.size());
		return (Integer) dirs.get(index);
	}
	
	public boolean randomChance(int range, int percentage) {
		Random rndGen = new Random();
		int value = rndGen.nextInt(range+1);
		if (value >= percentage)
			return true;
		return false;
	}
	
	public int randomValue(int min, int max) {
		Random rndGen = new Random();
		int value = rndGen.nextInt(max-min+1);
		return (min + value);
	}
	
	public static int DirectionFromString(String dirString) {
		if (dirString.equalsIgnoreCase("up"))
			return UP;
		if (dirString.equalsIgnoreCase("down"))
			return DOWN;
		if (dirString.equalsIgnoreCase("left"))
			return LEFT;
		if (dirString.equalsIgnoreCase("right"))
			return RIGHT;
		return NODIR;
	}
	
	public static int DirectionFromDeltaXY(int deltax, int deltay) {
		if (deltax != 0 && deltay != 0)
			return NODIR;	// not supported right now, no diagonal directions
		if (deltax < 0)
			return LEFT;
		else if (deltax > 0)
			return RIGHT;
		if (deltay < 0)
			return UP;
		else if (deltay > 0)
			return DOWN;
		return NODIR;
	}
	
	public static String StringFromDirection(int direction) {
		switch (direction) {
		case UP: return "up";
		case DOWN: return "down";
		case LEFT: return "left";
		case RIGHT: return "right";
		}
		return "unknown direction";
	}
}
